/* glballzup.c 
 *  X11 conversion by Nathan Laredo (laredo@gnu.org)
 *  GL hack by Mark Steele (ms@rapidsys.com)
 *  Win32 conversion by Nathan Laredo (laredo@gnu.org)
 */

#ifdef WIN32
#include <Windows.h>
#define M_PI 3.14159265358979
#endif

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
//#include <GL/glext.h>

#define SPHERE_SIZE	5U
#define SCREEN_WIDTH	480U
#define SCREEN_HEIGHT	480U

#define SPHERE_SIZE_FLOAT	((float)(SPHERE_SIZE))
#define SCREEN_WIDTH_FLOAT	((float)(SCREEN_WIDTH))


static int g_width = SCREEN_WIDTH;
static int g_height = SCREEN_HEIGHT;
static const char window_title[] = "Return of Ballzup 2: Ballz in 3D";

static int sphere_depth[SPHERE_SIZE * SPHERE_SIZE];

static int myscreen;

static GLfloat quad_att[3] = { 0.25, 0.0, 1/60.0 };

static float frand(void)
{
	return (rand() % 6280) * 0.001f;
}

static float frac(float x)
{
	return (x - floor(x));
}

static void knot_func_0(float t, float *x, float *y, float *z, float *scale)
{
	*x = sin(t + frand());
	*y = cos(t + frand());
	*z = cos(t + frand());
	*scale = 0.3f;
}

static void knot_func_1(float t, float *x, float *y, float *z, float *scale)
{
	*x = ((3 + sin(14 * t)) * cos(t)) * 0.4f;
	*y = (cos(14 * t)) * 0.4;
	*z = ((3 + sin(14 * t)) * sin(t)) * 0.4f;
	*scale = 0.4f;
}

static void knot_func_crusoe(float t, float *x, float *y, float *z,
			     float *scale)
{
	*x = t * sin(2 * t) / (M_PI * 2);
	*y = t * 0.07;
	*z = t * cos(2 * t) / (M_PI * 2);
	*scale = 0.4f;
}

static void do_half_frame(void)
{
	static float t = 0.0, tt;
	float rdiff[] = {1.0, 0.0, 0.0};
	float bdiff[] = {0.0, 0.0, 1.0};
	float blend;
	int kf;

	static int frame = 0;
	static time_t then, now;

	if (!frame)
		then = time(NULL);
	frame++;
	if (!(frame & 127)) {
		now = time(NULL);
		if (now > then)
			fprintf(stderr, "\r%d frames in %ds (%.4ffps)",
				frame>>1, now - then,
				(float) (frame >> 1) / (float) (now - then));
	}

	glLoadIdentity();

	if (frame & 1) {
		glClear(GL_DEPTH_BUFFER_BIT);
		glColorMask(GL_FALSE, GL_FALSE, GL_TRUE, GL_TRUE);
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(50.0, (float)g_width / (float) g_height,
			       1.0, 100000.0);
		glTranslated(-0.5, 0, 0);
		glMatrixMode(GL_MODELVIEW);
		glLightfv(GL_LIGHT0, GL_DIFFUSE, bdiff);
	} else {
		t += 0.015;
		glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glColorMask(GL_TRUE, GL_FALSE, GL_FALSE, GL_TRUE);
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(50.0, (float)g_width / (float)g_height,
			       1.0, 100000.0);
		glTranslated(0.5, 0, 0);
		glMatrixMode(GL_MODELVIEW);
		glLightfv(GL_LIGHT0, GL_DIFFUSE, rdiff);
	}

	kf = (int)((t * 0.5 + M_PI) / (2 * M_PI)) & 1;
	blend = cos(t * 0.5) * 0.5 + 0.5;
	srand(0);

	glTranslatef(0.0f, 0.0f, -15.0f);
	//glBegin(GL_POINTS);

	for (tt = 0.0; tt < 2 * M_PI; tt += M_PI / 180) {
		float x, y, z, x1, y1, z1, x2, y2, z2;
		float scale, scale1, scale2;
		float nx, ny, nz, ra, rb, rc;

		float screen_scale, screen_x, screen_y;

		knot_func_crusoe(tt, &x1, &y1, &z1, &scale1);
		switch (kf) {
		case 0:
			knot_func_0(tt, &x2, &y2, &z2, &scale2);
			break;
		default:
			knot_func_1(tt, &x2, &y2, &z2, &scale2);
		}

		x = x1 * (1 - blend) + x2 * blend;
		y = y1 * (1 - blend) + y2 * blend;
		z = z1 * (1 - blend) + z2 * blend;
		scale = scale1 * (1 - blend) + scale2 * blend;
		
		ra = sin(t * 1.2) * 5;
		rb = sin(t * 1.4) * 5;
		rc = sin(t * 1.6) * 5;

		nx = x * cos(rb) + z * -sin(rb);
		ny = y;
		nz = x * sin(rb) + z * cos(rb);
		
		x = nx;
		y = ny * cos(ra) + nz * -sin(ra);
		z = ny * sin(ra) + nz * cos(ra);

		nx = x * cos(rc) + y * -sin(rc);
		ny = x * sin(rc) + y * cos(rc);
		nz = z;
		
		x = nx; y = ny; z = nz;

		screen_scale = 4;

		screen_x = x * screen_scale;
		screen_y = y * screen_scale;
	
#if 0
		if (frame & 1)
			glColor3f((z+1.0f), 0.0f, 0.0f);
		else
			glColor3f(0.0f, 0.0f, (z+1.0f));

		glVertex3f(screen_x, screen_y, z*4);
#else
		glPushMatrix();
		glTranslatef(screen_x, screen_y, z*4);
		glCallList(1);
		glPopMatrix();
#endif
	}
	//glEnd(GL_POINTS);
	if (frame & 1) {
		glutSwapBuffers();
	}
}

static void do_one_frame(void)
{
	do_half_frame();	/* red */
	do_half_frame();	/* blue */
}

static void do_key(unsigned char k, int x, int y)
{
	exit(0);	/* exit on any keypress */
}

static void do_resize(int new_width, int new_height)
{
	g_width = new_width;
	g_height = new_height;
	glViewport(0,0, g_width, g_height);
}

static void idle(void)
{
	glutPostRedisplay();
}

static void visible(int vis)
{
	if(vis == GLUT_VISIBLE)
		glutIdleFunc(idle);
	else
		glutIdleFunc(NULL);
}

void init_display(int argc, char **argv)
{
#ifdef WIN32
	PROC foo;
#endif
	GLfloat light_position[] = { -15.0, 15.0, 15.0 };

	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);
	glutInitWindowSize(g_width,  g_height);
	myscreen = glutCreateWindow(window_title);
	glutDisplayFunc(do_one_frame);
	glutIdleFunc(idle);
	glutVisibilityFunc(visible);
	glutKeyboardFunc(do_key);
	glutReshapeFunc(do_resize);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(50.0, (float)g_width/(float)g_height, 1.0, 100000.0);
	//gluOrtho2D(0, g_width, 0, g_height);
	//glOrtho(0.0f, g_width, 0.0f, g_height, 0.0f, 100.0f);
	//glViewport(0,0, g_width, g_height);
	glMatrixMode(GL_MODELVIEW);

	glEnable(GL_DEPTH_TEST);

	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);  

#if 0
	glEnable(GL_POINT_SMOOTH);
	glPointSize(SPHERE_SIZE);
#else
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);
	glShadeModel(GL_SMOOTH);

	//glEnable(GL_BLEND);
	//glBlendFunc(GL_ONE, GL_ONE);

	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);

	glNewList(1, GL_COMPILE);
	glutSolidSphere(SPHERE_SIZE * 0.05, 10, 6);
	//glutSolidSphere(SPHERE_SIZE * 0.05, 3, 3);
	glEndList();
#endif

#ifdef WIN32
	foo = wglGetProcAddress("glPointParameterfvEXT");
	if (!foo)
		foo = wglGetProcAddress("glPointParameterfEXT");
	if (foo)
		foo(0x8129, quad_att);
#else
	glPointParameterfvEXT(GL_DISTANCE_ATTENUATION_EXT, quad_att);
#endif
	fprintf(stderr, "%s\n", glGetString(GL_EXTENSIONS));
}

int main(int argc, char **argv)
{

	init_display(argc, argv);

	glutMainLoop();
	exit(0);
}
