
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <math.h>

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;

const int g_width = 320;
const int g_height = 240;
const char window_title[] = "Return of Ballzup";
const char window_classname[] = "TestWindowClass";

#define SPHERE_SIZE 63U
#define SCREEN_WIDTH 320U
#define SCREEN_HEIGHT 240U

#define SCREEN_WIDTH_OVER_2 ((float)(SCREEN_WIDTH / 2))
#define SCREEN_HEIGHT_OVER_2 ((float)(SCREEN_HEIGHT / 2))
#define SPHERE_SIZE_FLOAT ((float)(SPHERE_SIZE))
#define SCREEN_WIDTH_FLOAT ((float)(SCREEN_WIDTH))

#define M_PI 3.1415926535897932384626433832741971

int *buffer_depth;
int *sphere_depth;
HANDLE heap;
u32 rand_seed = 0;

void srand(u32 x) { rand_seed = x; }
u32 rand() { return (rand_seed = rand_seed * 0x343fd + 0x269ec3) & 0xffff; }
float frand() { return (rand() % 6280)/1000.0f; }
float frac(float x) { return x - (int)x; }

int _fltused = 0x1234;
int _ftol(void)
{
     __asm {
          add esp, -4
          fistp dword ptr [esp]
          pop eax
     }
}

void SetClientSize(HWND hwnd, int width, int height)
{
    RECT client_rect, window_rect;
    GetClientRect(hwnd, &client_rect);
    GetWindowRect(hwnd, &window_rect);
    SetWindowPos(hwnd, NULL, 0, 0,
        width + ((window_rect.right - window_rect.left) -
            (client_rect.right - client_rect.left)),
        height + ((window_rect.bottom - window_rect.top) -
            (client_rect.bottom - client_rect.top)),
        SWP_NOMOVE);
}

void sphere_generate()
{
    float x, y = -1;
    int sx, sy, *sd = sphere_depth;
    const float sgm_d = 2.0f / SPHERE_SIZE;

    for (sy = 0; sy < SPHERE_SIZE; sy++, y += sgm_d)
        for (sx = 0, x = -1; sx < SPHERE_SIZE; sx++, x += sgm_d)
            *sd++ = (1 - sqrt(1 - (x*x + y*y))) * 65535;
}

static void put_sprite_depth_scale(int *src_depth, u32 ssize, int *dst_depth,
				   u32 pitch, int depth, float scale)
{
	u32 x, y, ix, idx, new_size;
	int *dstd, *srcd;

	idx = (1.0f / scale) * 65536;
	new_size = ssize * scale;

	for (y = 0; y < new_size; y++) {
		dstd = dst_depth + y * pitch;
		srcd = src_depth + (int)floor(y * (1.0f / scale)) * ssize;
		ix = 0;

		for (x = 0; x < new_size; x++) {
			if (srcd[ix >> 16] > 0)
				if (srcd[ix >> 16] + depth < *dstd)
					*dstd = srcd[ix >> 16] + depth;
			dstd++;
			ix += idx;
		}
	}
}

void view_buffer_depth(u32 *surface)
{
    int *src = buffer_depth;
    int i;

    for (i = 0; i < SCREEN_HEIGHT * SCREEN_WIDTH; i++)
        *surface++ = (u8)(*src++ * -0.00078 + 128) << 8; 
}

void knot_func_0(float t, float *x, float *y, float *z, float *scale)
{
    *x = sin(t+frand());
    *y = cos(t+frand());
    *z = cos(t+frand());
    *scale = 0.3;
}

void knot_func_1(float t, float *x, float *y, float *z, float *scale)
{
    *x = ((3+sin(14*t))*cos(t))*0.4;
    *y = (cos(14*t))*0.4;
    *z = ((3+sin(14*t))*sin(t))*0.4;
    *scale = 0.4;
}

static void knot_func_crusoe(float t, float *x, float *y, float *z,
			     float *scale)
{
	*x = t * sin(2 * t) / (M_PI * 2);
	*y = t * 0.07;
	*z = t * cos(2 * t) / (M_PI * 2);
	*scale = 0.4f;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch (msg)
    {
    case WM_DESTROY :
        PostQuitMessage(0);
        return 0;

    case WM_KEYDOWN :
        if (wParam == VK_ESCAPE)
        {
            DestroyWindow(hwnd);            
            return 0;
        }
    }

    return DefWindowProc(hwnd, msg, wParam, lParam);
}

void *malloc(size_t size)
{
     return HeapAlloc(heap, (DWORD)NULL, (SIZE_T)size);
}

void free(void *block)
{
     HeapFree(heap, (DWORD)NULL, (LPVOID)block);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
     LPSTR nCmdLine, int nCmdShow)
{
    struct BITMAPINFO bi;
    MSG msg;
    HWND hwnd;
    WNDCLASSEX wcx;
    HDC hdc_client, hdc_mem, hdc_screen;
    void *surface;
    int i, kf;
    float t, tt, blend;
    HANDLE bitmap_handle;

    wcx.cbSize = sizeof(wcx);
    wcx.style = CS_HREDRAW | CS_VREDRAW;
    wcx.lpfnWndProc = WndProc;
    wcx.cbClsExtra = 0;
    wcx.cbWndExtra = 0;
    wcx.hInstance = hInstance;
    wcx.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wcx.hCursor = 0;
    wcx.hbrBackground = (HBRUSH)GetStockObject(DKGRAY_BRUSH);
    wcx.lpszMenuName = NULL;
    wcx.lpszClassName = window_classname;
    wcx.hIconSm = LoadIcon(NULL, IDI_WINLOGO);
    RegisterClassEx(&wcx);

    hwnd = CreateWindowEx(WS_EX_CLIENTEDGE,
        window_classname, window_title,
        WS_OVERLAPPEDWINDOW,
        (GetSystemMetrics(SM_CXSCREEN) >> 1) - (g_width >> 1),
        (GetSystemMetrics(SM_CYSCREEN) >> 1) - (g_height >> 1),
        g_width, g_height,
        NULL, NULL, hInstance, NULL);

    ShowWindow(hwnd, SW_SHOW);
    UpdateWindow(hwnd);
    BringWindowToTop(hwnd);
    SetFocus(hwnd);
    SetClientSize(hwnd, 320, 240);


    hdc_screen = GetDC(NULL);
    surface = NULL;

    bi.bmiHeader.biBitCount = 32;
    bi.bmiHeader.biHeight = -g_height;
    bi.bmiHeader.biWidth = g_width;
    bi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    bi.bmiHeader.biCompression = BI_RGB;
    bi.bmiHeader.biSizeImage = 0;
    bi.bmiHeader.biPlanes = 1;

    bitmap_handle = CreateDIBSection(hdc_screen,
          &bi, DIB_RGB_COLORS, (void **)&surface,
          NULL, NULL);

    GdiFlush();

    hdc_client = GetDC(hwnd);
    hdc_mem = CreateCompatibleDC(hdc_client);
    SelectObject(hdc_mem, bitmap_handle);

    heap = GetProcessHeap();
    
    buffer_depth = (int *)malloc(SCREEN_WIDTH * SCREEN_HEIGHT * 4);
    sphere_depth = (int *)malloc(SPHERE_SIZE * SPHERE_SIZE * 4);

    sphere_generate();

    while (IsWindow(hwnd))
    {
        i = 0;
        for (int *clearz = buffer_depth;
            clearz != buffer_depth + SCREEN_WIDTH * SCREEN_HEIGHT; ++clearz, ++i)
            *clearz = 400000;

        t = (GetTickCount() / 4000.0f);
        blend = cos(t)*0.5+0.5;
	kf = (int)((t + M_PI) / (2 * M_PI)) & 1;
        srand(0);

        for (tt = 0; tt < M_PI; tt += M_PI / 180.0)
        {
            float x, y, z, x1, y1, z1, x2, y2, z2, scale, scale1, scale2;
            float nx, ny, nz, ra, rb, rc;

	    knot_func_crusoe(tt, &x1, &y1, &z1, &scale1);
	    if (kf)
		knot_func_0(tt, &x2, &y2, &z2, &scale2);
	    else
		knot_func_1(tt, &x2, &y2, &z2, &scale2);

            x = x1*(1-blend) + x2*blend;
            y = y1*(1-blend) + y2*blend;
            z = z1*(1-blend) + z2*blend;
            scale = scale1*(1-blend) + scale2*blend;

            ra = sin(t*1.2)*5;
            rb = sin(t*1.4)*5;
            rc = sin(t*1.6)*5;

            nx = x*cos(rb) + z*-sin(rb);
            ny = y;
            nz = x*sin(rb) + z*cos(rb);

            x = nx;
            y = ny*cos(ra) + nz*-sin(ra);
            z = ny*sin(ra) + nz*cos(ra);

            nx = x*cos(rc) + y*-sin(rc);
            ny = x*sin(rc) + y*cos(rc);
            nz = z;

            x = nx;
            y = ny;
            z = nz;

            float biasedz = z + 10;
            float screen_scale = 600;
            u32 dboffset;

            float screen_x = (x / biasedz) * screen_scale + (SCREEN_WIDTH/2);
            float screen_y = (y / biasedz) * screen_scale + (SCREEN_HEIGHT/2);
            float sprite_size = (5.0f / biasedz) * scale;

            dboffset = int(screen_x - sprite_size * 0.5 * SPHERE_SIZE) +
                int(screen_y - sprite_size * 0.5 * SPHERE_SIZE) * SCREEN_WIDTH;

            put_sprite_depth_scale(sphere_depth,
                SPHERE_SIZE, buffer_depth+dboffset, SCREEN_WIDTH,
                z*65536, sprite_size);
        }

        view_buffer_depth((u32 *)surface);

        int error = BitBlt(hdc_client, 0, 0, g_width, g_height,
            hdc_mem, 0, 0, SRCCOPY);

        while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    ReleaseDC(hwnd, hdc_client);
    DeleteDC(hdc_mem);
    DeleteObject(bitmap_handle);

    return msg.lParam;
}

int entry(void)
{
     return WinMain(GetModuleHandle(NULL), GetModuleHandle(NULL),
          GetCommandLine(), 0);
}



