/* 
 * 386iops.S -- My 1989 DOS 386 asm benchmark revisited
 * Last modified: 2 February 2000
 * This code is Copyright (C)1989-2000 Nathan Laredo
 * May be freely distributed in unmodified form
 *
 * Special thanks to vbostrom at intel for p6
 * optimization hints
 */
#ifdef linux
#include <asm/unistd.h>
#define DoSysCall1	int $0x80
#define DoSysCall2	int $0x80
#define DoSysCall3	int $0x80
#else
#include <sys/syscall.h>
#define __NR_signal	SYS_signal
#define __NR_setitimer	SYS_setitimer
#define __NR_write	SYS_write
#define __NR_exit	SYS_exit
#define DoSysCall3	call BSDSysCall3
#define DoSysCall2	call BSDSysCall2
#define DoSysCall1	call BSDSysCall1
#undef  SysCallType	int $0x80
#define SysCallType	lcall $7,$0
#endif

.data

expired: .byte 1, 2, 3, 4
Output: .asciz "0000000000 "
Return: .asciz "\r"

Intro1: .asciz "386IOPS v2.3  Last Revised 02 Feb 2000  (all values operations per second)\nADD        SUB        MUL        DIV        ROL        SHL        JMP\n" 

Message1: .asciz "\nAMD Opteron 246 @ 2GHz:\n5028206140 5009334680 0669496880 0050057600 5013754680 5014047900 0193736440\nMobile Celeron 400 MHz:\n0939680680 0943039980 0109861100 0014032340 0498378400 0546298620 0102551700\n\nNathan Laredo (laredo@gnu.org)\n4380 Albany Dr Apt 32, San Jose, CA 95129\n"

.text
	.align 16
#ifdef linux
.global _start
#endif
_start:
	/* print intro and header lines */
	movl  $Intro1,%ecx
	call  print
	/* trap signal 2 to do call exit routine below */
	movl  $2,%ebx
	movl  $doexit,%ecx
	movl  $__NR_signal,%eax
	DoSysCall2
back:	call  setup
	.align 16
doadd:  
	addl  %eax,%ebx
	addl  %eax,%edx
	addl  %eax,%esi
	addl  %eax,%edi
	addl  %eax,%ebx
	addl  %eax,%edx
	addl  %eax,%esi
	addl  %eax,%edi
	addl  %eax,%ebx
	addl  %eax,%edx
	addl  %eax,%esi
	addl  %eax,%edi
	addl  %eax,%ebx
	addl  %eax,%edx
	addl  %eax,%esi
	addl  %eax,%edi
	addl  %eax,%ebx
	addl  %eax,%edx
	addl  %eax,%esi
	addl  %eax,%edi
	incl  %ecx
	cmpl  $0,expired
	je    doadd
	call  output
	call  setup
	.align 16
dosub:
	subl  %eax,%ebx
	subl  %eax,%edx
	subl  %eax,%esi
	subl  %eax,%edi
	subl  %eax,%ebx
	subl  %eax,%edx
	subl  %eax,%esi
	subl  %eax,%edi
	subl  %eax,%ebx
	subl  %eax,%edx
	subl  %eax,%esi
	subl  %eax,%edi
	subl  %eax,%ebx
	subl  %eax,%edx
	subl  %eax,%esi
	subl  %eax,%edi
	subl  %eax,%ebx
	subl  %eax,%edx
	subl  %eax,%esi
	subl  %eax,%edi
	incl  %ecx
	cmpl  $0,expired
	je    dosub
	call  output
	xorl  %edx,%edx
	movl  $730410,%eax
	movl  $1,%ebx
	call  setup
	.align 16
domul:	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	imull  %ebx
	incl  %ecx
	cmpl  $0,expired
	je    domul
	call  output
	xorl  %edx,%edx
	movl  $730410,%eax
	movl  $1,%ebx
	call  setup
	.align 16
dodiv:	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	idivl  %ebx
	incl  %ecx
	cmpl  $0,expired
	je    dodiv
	call  output
	call  setup
	.align 16
dorol:	roll  %eax
	roll  %ebx
	roll  %edx
	roll  %esi
	roll  %edi
	roll  %ebp
	roll  %eax
	roll  %ebx
	roll  %edx
	roll  %esi
	roll  %eax
	roll  %ebx
	roll  %edx
	roll  %esi
	roll  %edi
	roll  %ebp
	roll  %eax
	roll  %ebx
	roll  %edx
	roll  %esi
	incl  %ecx
	cmpl  $0,expired
	je    dorol
	call  output
	call  setup
	.align 16
doshl: 
	shll  %eax
	shll  %ebx
	shll  %edx
	shll  %esi
	shll  %edi
	shll  %ebp
	shll  %eax
	shll  %ebx
	shll  %edx
	shll  %esi
	shll  %eax
	shll  %ebx
	shll  %edx
	shll  %esi
	shll  %edi
	shll  %ebp
	shll  %eax
	shll  %ebx
	shll  %edx
	shll  %esi
	incl  %ecx
	cmpl  $0,expired
	je    doshl
	call  output
	call  setup
	.align 16
dojmp: 
L001:	jmp L002
L002:	jmp L003
L003:	jmp L004
L004:	jmp L005
L005:	jmp L006
L006:	jmp L007
L007:	jmp L008
L008:	jmp L009
L009:	jmp L010
L010:	jmp L011
L011:	jmp L012
L012:	jmp L013
L013:	jmp L014
L014:	jmp L015
L015:	jmp L016
L016:	jmp L017
L017:	jmp L018
L018:	jmp L019
L019:	jmp L020
L020:	jmp L021
L021:	incl  %ecx
	cmpl  $0,expired
	je    dojmp
	call  output
	movl  $Return,%ecx
	call  print
	jmp   back

	/* handle alarm: set expired flag, setup signal handler */
	.align 16
timeup:	incl  expired
	movl  $14,%ebx
	movl  $timeup,%ecx
	movl  $__NR_signal,%eax
	DoSysCall2
	ret

	/* setup an alarm to et expired flag in one second */
	/* clear iteration counter (%ecx) for benchmark */
	.align 16
setup:	call  timeup
	movl  $1,%ebx
	movl  $__NR_alarm,%eax
	DoSysCall2
	movl  $0,expired
	xorl  %ecx,%ecx
	ret

	/* convert counter %ecx to ascii -- multiply counter by 10 */
	.align 16
counttoascii:
	addl  %ecx,%ecx			/* multiply by 2 */
	movl  %ecx,%eax
	movl  $10,%ebx
	movl  $9,%ecx		/* we have 9 digits to convert */
div10:  xorl  %edx,%edx		/* clear remainder */
	divl  %ebx		/* eax/ebx, remainder in edx, quot eax */
	addb  $0x30,%dl		/* convert remainder to ascii and store */
	movb  %dl,Output-1(%ecx)	/* store ascii digit */
	loop  div10		/* keep going for all 9 digits */
	ret

	/* write the string pointed to by %ecx to stdout */
	.align 16
print:  movl %ecx,%edx
        xorl %ebx,%ebx
        decl %edx
print_count:
        incl %edx
        cmpb (%edx),%bl
        jnz  print_count
        subl %ecx,%edx
        movl $__NR_write,%eax
	DoSysCall3
        ret

	/* output counter contained in %ecx */
	.align 16
output:
	call  counttoascii
	movl  $Output,%ecx
	call  print
	ret

	/* exit program, printing reference comparison message */
doexit:	movl  $Message1,%ecx
	call  print
	xorl  %ebx,%ebx
	movl  $__NR_exit,%eax
	DoSysCall1	/* exit here and never return */
	int   $3	/* trap out if we get to here */

	/* wrapper for bsd syscalls */
BSDSysCall3:
	pushl  %edx
BSDSysCall2:
	pushl  %ecx
BSDSysCall1:
	pushl  %ebx
	pushl  %eax
	lcall  $7,$0
	ret
