/* LM78 reader
 * last modified 1/16/98: removed all floating point
 *
 * Nathan Laredo (laredo@gnu.org)
 */
#include <stdio.h>
#include <asm/io.h>
#define LM78_BASE 0x290
#define LM78_ADDR (LM78_BASE + 0x5)
#define LM78_DATA (LM78_BASE + 0x6)
static unsigned char value_ram[32];

int main(argc, argv)
int argc;
char **argv;
{
	register int i;
	if(iopl(3)) {
	   fprintf(stderr,"Unable to set iopl3.  Must run as uid 0\n");
	   exit(1);
        }
	outb(0x47,LM78_ADDR);
	outb(0x50,LM78_DATA);	/* set both divisors to 2 */
	if ((inb(LM78_DATA) & 0xf0) != 0x50) {
	   fprintf(stderr,"LM78 not detected\n");
	   exit(1);
        }
	outb(0x40,LM78_ADDR);
	outb(0x1,LM78_DATA);	/* start monitoring */
	outb(0x60,LM78_ADDR);
	sleep(2);		/* let readings settle (1.5s) */
	for (i=0; i < 32; i++)
	    value_ram[i] = inb(LM78_DATA);
	iopl(0);
	if (value_ram[8] == 255)
		value_ram[8] = 0;
	if (value_ram[9] == 255)
		value_ram[9] = 0;
	if (value_ram[10] == 255)
		value_ram[10] = 0;
	printf("System Monitor Status:\nTemp:%3dC\t", (char)value_ram[7]);
	i = value_ram[0] * 16;
	printf("In0: %2d.%03dV\t", i / 1000, i % 1000);
	i = value_ram[1] * 16;
	printf("In1: %2d.%03dV\t", i / 1000, i % 1000);
	i = value_ram[2] * 16;
	printf("In2: %2d.%03dV\n", i / 1000, i % 1000);
	i = value_ram[3] * 16 * 166 / 100;
	printf("In3: %2d.%03dV\t", i / 1000, i % 1000);
	i = value_ram[4] * 16 * 384 / 100;
	printf("In4: %2d.%03dV\t", i / 1000, i % 1000);
	i = value_ram[5] * 16 * 355 / 100;
	printf("In5:-%d.%03dV\t", i / 1000, i % 1000);
	i = value_ram[6] * 16 * 155 / 100;
	printf("In6: -%d.%03dV\n", i / 1000, i % 1000);
	if (value_ram[8])
	    printf("Fan1: %5d\t", 675000 / value_ram[8]);
	if (value_ram[9])
	    printf("Fan2: %5d\t", 675000 / value_ram[9]);
	if (value_ram[10])
	    printf("Fan3: %5d", 675000 / value_ram[10]);
	printf("\n");
	exit(0);
}
