/* ccdebug.c 
 *   by Nathan Laredo (laredo@gnu.org)
 */
#undef  PAL_DECODE
#define DO_LINE 11
#undef  DATA_FROM_FILE "/home/ftp/vbidata"

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <linux/types.h>
#include <math.h>

unsigned char vbibuf[65536];
unsigned char halfmhz[2048];	/* precalculated 0.5MHz cosine wave(for cc) */
unsigned char threemhz[2048];	/* precalculated 3MHz cosine wave(intercast)*/
#ifndef PAL_DECODE
#define HALFMHZ (2 * 0.503 * 3.14159265358979 / 28.636363)
#define THREEMHZ (2 * 2.5 * 3.14159265358979 / 28.636363)
#else
#define HALFMHZ (2 * 0.500 * 3.14159265358979 / 35.468950)
#define THREEMHZ (2 * 2.7 * 3.14159265358979 / 35.468950)
#endif
int pll = 0;

char *ccode = " !\"#$%&'()a+,-./0123456789:;<=>?@abcdefghijklmnopqrstuvwxyz[e]iouabcdefghijklmnopqrstuvwxyzc/Nn.";	/* this is NOT exactly right */

char outbuf[2048];

void makecostable(unsigned char *table, float k)
{
    int i;
    for (i=0; i<2048; i++)
	table[i] = (unsigned char)(84.0 + 40.0 * cos(k * i));
}

int parityok(int n)
{				/* check parity for 2 bytes packed in n */
    int j, k;
    for (k = 0, j = 0; j < 7; j++)
	if (n & (1 << j))
	    k++;
    if ((k & 1) && (n & 0x80))
	return 0;
    for (k = 0, j = 8; j < 15; j++)
	if (n & (1 << j))
	    k++;
    if ((k & 1) && (n & 0x8000))
	return 0;
    return 1;
}

int decodebit(unsigned char *data, int threshold)
{
    return ((data[0] + data[1] + data[2] + data[3] + data[4] + data[5] +
	data[6] + data[7] + data[8] + data[9] + data[10] + data[11] +
	data[12] + data[13] + data[14] + data[15] + data[16] + data[17] +
	data[18] + data[19] + data[20] + data[21] + data[22] + data[23] +
	data[24] + data[25] + data[26] + data[27] + data[28] + data[29] +
	data[30] + data[31])>>5 > threshold);
}

int ccdecode(unsigned char *vbiline)
{
    int max = 0, maxval = 0, minval = 255, i = 0, clk = 0, tmp = 0;
    int sample, packedbits = 0;

    for (i=0; i<250; i++) {
	sample = vbiline[i];
	if (sample - maxval > 10)
	    (maxval = sample, max = i);
	if (sample < minval)
	    minval = sample;
	if (maxval - sample > 40)
	    break;
    }
    sample = ((maxval + minval) >> 1);
    pll = max;

    /* found clock lead-in, double-check start */
#ifndef PAL_DECODE
    i = max + 478;
#else
    i = max + 538;
#endif
    if (!decodebit(&vbiline[i], sample))
	return 0;
#ifndef PAL_DECODE
    tmp = i + 57;		/* tmp = data bit zero */
#else
    tmp = i + 71;
#endif
    for (i = 0; i < 16; i++) {
#ifndef PAL_DECODE
	clk = tmp + i * 57;
#else
	clk = tmp + i * 71;
#endif
	if (decodebit(&vbiline[clk], sample)) {
	    packedbits |= 1 << i;
	}
    }
    if (parityok(packedbits))
	return packedbits;
    return 0;
}				/* ccdecode */


int ProcessLine(unsigned char *s)
{
    int w1, b1, b2;
    static int lastchar = 0, mode = 0;
    static int nocc = 0;
    int m, n;

    m = strlen(outbuf);
    w1 = ccdecode(s);
    if (!w1)
	nocc++;

    b1 = w1 & 0x7f;
    b2 = (w1 >> 8) & 0x7f;
    if ((b1 & 96)) {
	if (b1 > 31) {
	    strncat(outbuf, &ccode[b1 - 32], 1);
	    if (lastchar == '.' || lastchar == '['
		|| lastchar == '>' || lastchar == ']'
		|| lastchar == '!' || lastchar == '?')
		outbuf[strlen(outbuf) - 1] =
		    toupper(ccode[b1 - 32]);
	    if (b1 > 32)
		lastchar = ccode[b1 - 32];
	}
	if (b2 > 31) {
	    strncat(outbuf, &ccode[b2 - 32], 1);
	    if (lastchar == '.' || lastchar == '['
		|| lastchar == '>' || lastchar == ']'
		|| lastchar == '!' || lastchar == '?')
		outbuf[strlen(outbuf) - 1] =
		    toupper(ccode[b2 - 32]);
	    if (b2 > 32)
		lastchar = ccode[b2 - 32];
	}
    }
    if (!(b1 & 96) && b1 && *outbuf)
	if (outbuf[strlen(outbuf) - 1] != ' ')
	    strncat(outbuf, ccode, 1);
    n = strlen(outbuf);
    if (!(b1 & 96) && b1 && *outbuf) {
	if (++mode > 4) {
	    fprintf(stderr, "%s\n", outbuf);
	    *outbuf = 0;
	    mode = 0;
	}
    }
    return n - m;
}				/* ProcessLine */

int main(int argc, char **argv)
{
    fd_set rdfs;
    int vbifd, done = 0, i, j = DO_LINE * 2048;
    unsigned int *vbicount, oldcount = 0, dropcount = 0, scrollwait = 0;
    int filter;

#ifdef DATA_FROM_FILE
    if ((vbifd = open(DATA_FROM_FILE, O_RDONLY)) < 0) {
	perror("open /dev/vbi0");
	exit(1);
    }
#else
    if ((vbifd = open("/dev/vbi0", O_RDONLY)) < 0) {
	perror("open /dev/vbi0");
	exit(1);
    }
#endif
    makecostable(halfmhz, HALFMHZ);
    makecostable(threemhz, THREEMHZ);

    /* Main event loop */
    while (!done) {
	FD_ZERO(&rdfs);
	FD_SET(vbifd, &rdfs);
	select(FD_SETSIZE, &rdfs, NULL, NULL, NULL);
	if (FD_ISSET(vbifd, &rdfs)) {
	    if (read(vbifd, vbibuf, 65536) < 65536)
		done++;
	    vbicount = (unsigned int *) &vbibuf[65532];
	    if (oldcount == *vbicount)
		continue;
	    if (oldcount && oldcount + 1 != *vbicount) {
		dropcount += (*vbicount - oldcount);
	    }
	    oldcount = *vbicount;
	    scrollwait += ProcessLine(&vbibuf[j]);
	    if (1)
	    for (i = 0; i < 2044; i++) {
		filter = vbibuf[i + j] + vbibuf[i + j + 1] +
			vbibuf[i + j + 2] + vbibuf[i + j + 3] +
			vbibuf[i + j + 4] + vbibuf[i + j + 5] +
			vbibuf[i + j + 6] + vbibuf[i + j + 7];
		filter>>=3;
		vbibuf[i + j] = vbibuf[i + j + 1] =
		    vbibuf[i + j + 2] = vbibuf[i + j + 3] =
		    vbibuf[i + j + 4] = vbibuf[i + j + 5] =
		    vbibuf[i + j + 6] = vbibuf[i + j + 7] = filter;
		filter = vbibuf[2044- i + j] + vbibuf[2044- i + j + 1] +
			vbibuf[2044 - i + j + 2] + vbibuf[2044- i + j + 3] +
			vbibuf[2044 - i + j + 4] + vbibuf[2044- i + j + 5] +
			vbibuf[2044 - i + j + 6] + vbibuf[2044- i + j + 7];
		filter>>=3;
		vbibuf[2044- i + j] = vbibuf[2044- i + j + 1] =
		    vbibuf[2044 - i + j + 2] = vbibuf[2044 - i + j + 3] =
		    vbibuf[2044 - i + j + 4] = vbibuf[2044 - i + j + 5] =
		    vbibuf[2044 - i + j + 6] =
		    vbibuf[2044 - i + j + 7] = filter;
	    }
#ifdef DATA_FROM_FILE
	    usleep(333333);
#endif
	}
    }				/* while */
    close(vbifd);
    exit(0);
}				/* main */
