/* ciotest.c 
 *   by Nathan Laredo (laredo@gnu.org)
 *
 * ChangeLog:
 * 28 Feb 01 Console version
 * 22 Feb 01 Initial version
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <linux/types.h>
#include <sys/mman.h>

volatile int *framebuf;
unsigned char savebuf[131072];

void init_display(void)
{
	int fd;

	if ((fd = open("/dev/mem", O_RDWR)) < 0) {
		perror("open /dev/mem");
		exit(1);
	}
#if 0
	framebuf = mmap((void *)0x0, 131072, PROT_READ|PROT_WRITE,
			MAP_FIXED|MAP_SHARED, fd, 0xa0000);
#else
	framebuf = mmap((void *)0x0, 131072, PROT_READ|PROT_WRITE,
			MAP_FIXED|MAP_SHARED, fd, 0xe8000000);
#endif

	if (framebuf == (int *)0xffffffff) {
		perror("mmap /dev/mem offset 0xa0000 failed");
	}
	fprintf(stderr, "Mapped 64k physical memory at 0xa0000 to 0x%08x.\n",
			(int)framebuf);

	memcpy(savebuf, framebuf, 131072);

	fprintf(stderr, "%08x: ", (int)framebuf);

	for (fd = 0; fd < 16; fd++)
		fprintf(stderr,"%02x ", savebuf[fd]);

	fprintf(stderr, "\n");

}

int main(int argc, char **argv)
{
	struct timeval tv_start, tv_stop;
	unsigned int i;
	unsigned char data = 0x00;

	init_display();

	fprintf(stderr, "\nTesting sequential video memory burst writes.\n");
	gettimeofday(&tv_start, NULL);

	for (i = 0; i < 2929; i++) {
		data ^= 0xff;
		memset(framebuf, data, 131072);
	}

	gettimeofday(&tv_stop, NULL);

	fprintf(stderr, "wrote %d bytes to sequential video mem addresses.\n",
			131072 * i);
	fprintf(stderr, "stop time  = %10d.%06d\n", (int)tv_stop.tv_sec,
			(int)tv_stop.tv_usec);
	fprintf(stderr, "start time = %10d.%06d\n", (int)tv_start.tv_sec,
			(int)tv_start.tv_usec);
	tv_stop.tv_usec -= tv_start.tv_usec;
	tv_stop.tv_sec -= tv_start.tv_sec;
	if (tv_stop.tv_usec < 0) {
		tv_stop.tv_usec += 1000000;
		tv_stop.tv_sec--;
	}
	fprintf(stderr, "elapsed    = %10d.%06d\t", (int)tv_stop.tv_sec,
			(int)tv_stop.tv_usec);

	fprintf(stderr, "%16.6f bytes/sec\n\n", (float)(131072 * i) /
		((float)tv_stop.tv_sec + (float)tv_stop.tv_usec / 1000000.0));
	memcpy(framebuf, savebuf, 131072);
#if 0
	fprintf(stderr, "Testing 32-bit fixed address video memory writes.\n");

	gettimeofday(&tv_start, NULL);

	for (i = 0; i < 384000000; i++) {
		framebuf[0] = i;
	}

	gettimeofday(&tv_stop, NULL);

	fprintf(stderr, "wrote %d 32-bit writes at a "
			"fixed videomem address.\n", i);
	fprintf(stderr, "stop time  = %10d.%06d\n", (int)tv_stop.tv_sec,
			(int)tv_stop.tv_usec);
	fprintf(stderr, "start time = %10d.%06d\n", (int)tv_start.tv_sec,
			(int)tv_start.tv_usec);
	tv_stop.tv_usec -= tv_start.tv_usec;
	tv_stop.tv_sec -= tv_start.tv_sec;
	if (tv_stop.tv_usec < 0) {
		tv_stop.tv_usec += 1000000;
		tv_stop.tv_sec--;
	}
	fprintf(stderr, "elapsed    = %10d.%06d\t", (int)tv_stop.tv_sec,
			(int)tv_stop.tv_usec);

	fprintf(stderr, "%16.6f bytes/sec\n", (4.0 * (float)i) /
		((float)tv_stop.tv_sec + (float)tv_stop.tv_usec / 1000000.0));
#endif

	memcpy(framebuf, savebuf, 131072);

	exit(0);
}
