#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <linux/fb.h>
#include <sys/ioctl.h>

/* the default colour table, for VGA+ colour systems */
int default_red[] =
{0x00, 0xaa, 0x00, 0xaa, 0x00, 0xaa, 0x00, 0xaa,
 0x55, 0xff, 0x55, 0xff, 0x55, 0xff, 0x55, 0xff};
int default_grn[] =
{0x00, 0x00, 0xaa, 0x55, 0x00, 0x00, 0xaa, 0xaa,
 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff};
int default_blu[] =
{0x00, 0x00, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0xaa,
 0x55, 0x55, 0x55, 0x55, 0xff, 0xff, 0xff, 0xff};
int main(int argc, char **argv)
{
    unsigned short i, j, r[256], g[256], b[256];
    struct fb_cmap cmap;
    int f;

    /* this generates the tvset pseudocolor map */
    for (i = 0; i < 256; i++) {
	j = i - 16;
	if (i < 16 || i > 240) {
	    if (i > 239)
		j = i - 240;
	    else
		j = i;
	    r[j] = default_red[j]*255;
	    g[j] = default_grn[j]*255;
	    b[j] = default_blu[j]*255;
	} else {
	    r[i] = ((j % 25) / 5) * 16383;
	    g[i] = (j / 25) * 8191;
	    b[i] = (j % 5) * 16383;
	}
    }

    if ((f = open("/dev/fb0", O_RDWR)) < 0) {
	perror(argv[1]);
	exit(1);
    }
    cmap.red = r;
    cmap.green = g;
    cmap.blue = b;
    cmap.transp = NULL;
    cmap.start = 0;
    cmap.len = 256;
    ioctl(f, FBIOPUTCMAP, &cmap);
    close(f);
    exit(0);
}
