/* xvbidebug.c 
 *   by Nathan Laredo (laredo@gnu.org)
 */
#undef  PAL_DECODE
#define DO_LINE 11
#undef  DATA_FROM_FILE "/home/ftp/vbidata"
#undef  PREFILTER_DATA 2

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <linux/types.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Intrinsic.h>

Display *mydisplay;
Window mywindow;
Pixmap mypixmap;
GC mygc, mygc2, mygcbg;
XGCValues gcvals;
XEvent myevent;
int myscreen;
XSizeHints myhint;
KeySym mykey;
XColor mycolor;
XFontStruct *font_struct;
unsigned long myforeground, mybackground;
XWindowAttributes attribs;	/* for vis, depth, width, height */
XSetWindowAttributes myattribs;	/* for window creation */
XPoint vbipoints[1600];		/* for drawing data */
long myevents;			/* keep track of our events */
char title[4096];		/* window title */
unsigned char vbibuf[65536];
char marquee[384];

char *ccode = " !\"#$%&'()a+,-./0123456789:;<=>?@abcdefghijklmnopqrstuvwxyz[e]iouabcdefghijklmnopqrstuvwxyzc/Nn.";	/* this is NOT exactly right */

char outbuf[2048];

int parityok(int n)
{				/* check parity for 2 bytes packed in n */
#if 1
    return 1;
#else
    int j, k;
    for (k = 0, j = 0; j < 7; j++)
	if (n & (1 << j))
	    k++;
    if ((k & 1) && (n && 0x80))
	return 0;
    for (k = 0, j = 8; j < 15; j++)
	if (n & (1 << j))
	    k++;
    if ((k & 1) && (n && 0x8000))
	return 0;
    return 1;
#endif
}

#ifdef PREFILTER_DATA
#define NOISE 8
#else
#define NOISE 45
#endif

int decodebit(unsigned char *data, int threshold)
{
    int i, sum = 0;
    for (i = 0; i < 32; i++)
	sum += data[i];
    return (sum > (threshold << 5));
}
#ifndef PAL_DECODE
int maxpos[7] =
{200, 260, 320, 380, 440, 500, 600};
#else
int maxpos[7] =
{250, 325, 400, 475, 550, 650, 750};
#endif

int ccdecode(unsigned char *vbiline)
{
    int max[7], min[7], val[7], i, clk, tmp, sample, packedbits = 0;

    for (clk = 0; clk < 7; clk++)
	max[clk] = min[clk] = val[clk] = -1;
    clk = tmp = 0;
    i = 15;
    while (clk < 7 && i < maxpos[clk]) {	/* find and lock all 7 clocks */
	sample = vbiline[i];
	if (max[clk] < 0) {	/* find maximum value before drop */
	    if (sample > 60 && sample > val[clk])
		(val[clk] = sample, tmp = i);	/* mark new maximum found */
	    else if (val[clk] - sample > NOISE) {	/* far enough */
		XDrawLine(mydisplay, mypixmap, mygc, tmp >> 0, 30, tmp >> 0, 128);
		max[clk] = tmp;
		i = tmp + 16;
		if (clk) {
		    tmp -= max[clk - 1];
		    sprintf(title, "%d", tmp);
		    XDrawString(mydisplay, mypixmap, mygc,
			    min[clk - 1] >> 0, 50, title, strlen(title));
#ifndef PAL_DECODE
		    if (tmp < 42 || tmp > 84)
#else
		    if (tmp < 52 || tmp > 105)
#endif
			return 0;	/* wrong frequency clock */
		}
	    }
	} else {		/* find minimum value after drop */
	    if (sample < val[clk])
		(val[clk] = sample, tmp = i);	/* mark new minimum found */
	    else if (sample - val[clk] > NOISE) {	/* searched far enough */
		if (clk < 6) {
		    sprintf(title, "%d", val[clk]);
		    XDrawString(mydisplay, mypixmap, mygc,
				tmp >> 0, 225, title, strlen(title));
		    XDrawLine(mydisplay, mypixmap, mygc, tmp >> 0, 226,
			      tmp >> 0, 256);
		}
		min[clk++] = tmp;
		i = tmp + 16;
	    }
	}
	i++;
    }
    if (clk != 7)		/* failure to locate clock lead-in */
	return 0;

    /* calculate threshold */
    sample = 7 + ((vbiline[max[6]] + vbiline[min[6]]) >> 1);

    /* found clock lead-in, double-check start */
#ifndef PAL_DECODE
    i = max[6] + 144;
#else
    i = max[6] + 179;
#endif
    if (!decodebit(&vbiline[i], sample))
	return 0;
    XDrawLine(mydisplay, mypixmap, mygc, i >> 0, 30, i >> 0, 256);
#ifndef PAL_DECODE
    tmp = i + 57;		/* tmp = data bit zero */
#else
    tmp = i + 71;
#endif
    for (i = 0; i < 16; i++) {
#ifndef PAL_DECODE
	clk = tmp + i * 57;
#else
	clk = tmp + i * 71;
#endif
	if (decodebit(&vbiline[clk], sample)) {
	    XDrawLine(mydisplay, mypixmap, mygc, clk >> 0, 30,
		      clk >> 0, 256 - sample);
	    packedbits |= 1 << i;
	} else
	    XDrawLine(mydisplay, mypixmap, mygc, clk >> 0, 256 - sample,
		      clk >> 0, 256);
    }
    if (parityok(packedbits))
	return packedbits;
    return 0;
}				/* ccdecode */


int ProcessLine(unsigned char *s)
{
    int w1, b1, b2;
    static lastchar = 0, mode = 0;
    static nocc = 0;
    int m, n;

    m = strlen(outbuf);
    w1 = ccdecode(s);
    if (!w1)
	nocc++;
    sprintf(title, "%d", nocc);
    XDrawString(mydisplay, mypixmap, mygc, 20, 245, title, strlen(title));

    b1 = w1 & 0x7f;
    b2 = (w1 >> 8) & 0x7f;
    if ((b1 & 96)) {
	if (b1 > 31) {
	    strncat(outbuf, &ccode[b1 - 32], 1);
	    if (lastchar == '.' || lastchar == '['
		|| lastchar == '>' || lastchar == ']'
		|| lastchar == '!' || lastchar == '?')
		outbuf[strlen(outbuf) - 1] =
		    toupper(ccode[b1 - 32]);
	    if (b1 > 32)
		lastchar = ccode[b1 - 32];
	}
	if (b2 > 31) {
	    strncat(outbuf, &ccode[b2 - 32], 1);
	    if (lastchar == '.' || lastchar == '['
		|| lastchar == '>' || lastchar == ']'
		|| lastchar == '!' || lastchar == '?')
		outbuf[strlen(outbuf) - 1] =
		    toupper(ccode[b2 - 32]);
	    if (b2 > 32)
		lastchar = ccode[b2 - 32];
	}
    }
    if (!(b1 & 96) && b1 && *outbuf)
	if (outbuf[strlen(outbuf) - 1] != ' ')
	    strncat(outbuf, ccode, 1);
    n = strlen(outbuf);
    if (n - m)
	strncat(marquee,&outbuf[m], n - m);
    if (!(b1 & 96) && b1 && *outbuf) {
	if (++mode > 14) {
	    fprintf(stderr, "%s\n", outbuf);
	    *outbuf = 0;
	    mode = 0;
	}
    }
    return n - m;
}				/* ProcessLine */

void init_display(int argc, char **argv)
{

    if (!getenv("DISPLAY")) {
	fprintf(stderr, "DISPLAY not set.\n");
	exit(1);
    }
    if (!(mydisplay = XOpenDisplay(getenv("DISPLAY")))) {
	fprintf(stderr, "Unable to open display.\n");
	exit(1);
    }
    mybackground = BlackPixel(mydisplay, myscreen);
    myforeground = WhitePixel(mydisplay, myscreen);
    myhint.width = 1600;
    myhint.height = 256;
    myhint.max_width = 1600;
    myhint.max_height = 256;
    myhint.min_width = 1600;
    myhint.min_width = 256;
    myhint.x = 0;
    myhint.y = 580;
    /* to add aspect ratio restriction, add to mask below */
    myhint.flags = PSize | PMinSize | PMaxSize | PPosition;
    myevents = myattribs.event_mask = KeyPressMask | ButtonPressMask;
    myattribs.background_pixel = mybackground;
    mywindow = XCreateWindow(mydisplay, DefaultRootWindow(mydisplay),
	0, 0, myhint.width, myhint.height, 0, attribs.depth, InputOutput,
		  attribs.visual, CWEventMask | CWBackPixel, &myattribs);
    sprintf(title, "xvbidebug %d", DO_LINE);
    XSetStandardProperties(mydisplay, mywindow, title, title, None, argv,
			   argc, &myhint);
    gcvals.foreground = mybackground;
    gcvals.background = myforeground;
    mygcbg = XCreateGC(mydisplay, mywindow,
	GCForeground | GCBackground, &gcvals);
    gcvals.foreground = myforeground;
    gcvals.background = mybackground;
    mygc = XCreateGC(mydisplay, mywindow, GCForeground | GCBackground, &gcvals);
    mycolor.flags = DoRed | DoGreen | DoBlue;
    mycolor.red = 32767;
    mycolor.green = 49152;
    mycolor.blue = 65535;
    mycolor.pad = 0;
    XAllocColor(mydisplay, DefaultColormap(mydisplay, myscreen), &mycolor);
    gcvals.foreground = mycolor.pixel;
    mygc2 = XCreateGC(mydisplay, mywindow,
		      GCForeground | GCBackground, &gcvals);
    XMapRaised(mydisplay, mywindow);
    mypixmap = XCreatePixmap(mydisplay, mywindow, 1600, 256,
	DefaultDepth(mydisplay, myscreen));
    XFillRectangle(mydisplay, mypixmap, mygcbg, 0, 0, 1600, 256);
    XSetWindowBackgroundPixmap(mydisplay, mywindow, mypixmap);
}

int main(int argc, char **argv)
{
    fd_set rdfs;
    int vbifd, xfd, done = 0, i, j = DO_LINE * 2048, k, m, animate = 0;
    unsigned int *vbicount, oldcount = 0, dropcount = 0, scrollwait = 0;

#ifdef DATA_FROM_FILE
    if ((vbifd = open(DATA_FROM_FILE, O_RDONLY)) < 0) {
	perror("open /dev/vbi");
	exit(1);
    }
#else
    if ((vbifd = open("/dev/vbi", O_RDONLY)) < 0) {
	perror("open /dev/vbi");
	exit(1);
    }
#endif
    init_display(argc, argv);
    for (i = 0; i < 119; i++)
	marquee[i] = ' ';
    marquee[i] = 0;

    xfd = ConnectionNumber(mydisplay);
    for (i = 0; i < 1600; i++)
	vbipoints[i].x = i;

    /* Main event loop */
    while (!done) {
	FD_ZERO(&rdfs);
	FD_SET(xfd, &rdfs);
	FD_SET(vbifd, &rdfs);
	select(FD_SETSIZE, &rdfs, NULL, NULL, NULL);
	if (FD_ISSET(xfd, &rdfs))
	    while (XPending(mydisplay)) {
		XNextEvent(mydisplay, &myevent);
		j += 2048;
		if (j >= 65536)
		    j = 0;
		sprintf(title, "xvbidebug %d", j >> 11);
		XStoreName(mydisplay, mywindow, title);
	    }
	if (FD_ISSET(vbifd, &rdfs)) {
	    if (read(vbifd, vbibuf, 65536) < 65536)
		done++;
	    vbicount = (unsigned int *) &vbibuf[65532];
	    if (oldcount && oldcount + 1 != *vbicount) {
		dropcount += (*vbicount - oldcount);
	    }
	    oldcount = *vbicount;
	    XFillRectangle(mydisplay, mypixmap, mygcbg, 0, 0, 1600, 256);
#ifdef PREFILTER_DATA
	    for (i = 0; i < 1600; i++)
		vbipoints[i].y = 256 - vbibuf[i + j];
	    for (m = 0; m < PREFILTER_DATA; m++)
		if (m & 1)
#ifndef PAL_DECODE
		    for (i = 3; i < 1600; i++) {
#else
		    for (i = 3; i < 2044; i++) {
#endif
			k = vbibuf[i + j - 3] + vbibuf[i + j - 2] +
			    vbibuf[i + j - 1] + vbibuf[i + j] +
			    vbibuf[i + j + 1] + vbibuf[i + j + 2] +
			    vbibuf[i + j + 3] + vbibuf[i + j + 4];
			k >>= 3;
			vbibuf[i + j - 3] = vbibuf[i + j - 2] =
			    vbibuf[i + j - 1] = vbibuf[i + j] =
			    vbibuf[i + j + 1] = vbibuf[i + j + 2] =
			    vbibuf[i + j + 3] = vbibuf[i + j + 4] = k;
		} else
#ifndef PAL_DECODE
		    for (i = 1600; i > 3; i--) {
#else
		    for (i = 2044; i > 3; i--) {
#endif
			k = vbibuf[i + j - 3] + vbibuf[i + j - 2] +
			    vbibuf[i + j - 1] + vbibuf[i + j] +
			    vbibuf[i + j + 1] + vbibuf[i + j + 2] +
			    vbibuf[i + j + 3] + vbibuf[i + j + 4];
			k >>= 3;
			vbibuf[i + j - 3] = vbibuf[i + j - 2] =
			    vbibuf[i + j - 1] = vbibuf[i + j] =
			    vbibuf[i + j + 1] = vbibuf[i + j + 2] =
			    vbibuf[i + j + 3] = vbibuf[i + j + 4] = k;
		    }
	    XDrawPoints(mydisplay, mypixmap, mygc2, vbipoints,
			1600, CoordModeOrigin);
#endif
	    sprintf(title, "%d %d", dropcount, *vbicount);
	    for (i = 0; i < 1600; i++)
		vbipoints[i].y = 256 - vbibuf[i + j];
	    XDrawString(mydisplay, mypixmap, mygc, 20, 20,
			title, strlen(title));
	    XDrawLines(mydisplay, mypixmap, mygc, vbipoints,
		       1600, CoordModeOrigin);
	    scrollwait += ProcessLine(&vbibuf[j]);
	    if (animate)
		animate -= ((scrollwait > 100) ? animate : 2);
	    if (!animate && scrollwait > 1) {
		strcpy(marquee, &marquee[2]);
		scrollwait -= 2;
		animate = (scrollwait > 100) ? 0 : 12;
	    }
	    sprintf(title, "%s", marquee);
	    XDrawString(mydisplay, mypixmap, mygc, 90+animate, 20,
			title, strlen(title));
	    XClearWindow(mydisplay, mywindow);	/* repaint */
	    XFlush(mydisplay);
	}
    }				/* while */
    close(vbifd);
    XFreeGC(mydisplay, mygc);
    XFreeGC(mydisplay, mygc2);
    XFreeGC(mydisplay, mygcbg);
    XFreePixmap(mydisplay, mypixmap);
    XDestroyWindow(mydisplay, mywindow);
    XCloseDisplay(mydisplay);
    exit(0);
}				/* main */
