/* generate a tvset pseudocolor colormap and map input rgb file source
 * (from convert using tvsetcolormap.ppm) to pseudocolor raw 128x128
 * file.  Colors are matched on lowest delta rgb.
 */
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

int nextline(char *s, int i)
{
    while(s[i] != '\n' && i < 1023) i++;
    if (s[i] != '\n') {
	fprintf(stderr, "bad ppm file\n");
	exit(1);
    }
    return (i + 1);
}
/* the default colour table, for VGA+ colour systems */
int default_red[] = {0x00,0xaa,0x00,0xaa,0x00,0xaa,0x00,0xaa,
    0x55,0xff,0x55,0xff,0x55,0xff,0x55,0xff};
int default_grn[] = {0x00,0x00,0xaa,0x55,0x00,0x00,0xaa,0xaa,
    0x55,0x55,0xff,0xff,0x55,0x55,0xff,0xff};
int default_blu[] = {0x00,0x00,0x00,0x00,0xaa,0xaa,0xaa,0xaa,
    0x55,0x55,0x55,0x55,0xff,0xff,0xff,0xff};
main(int argc, char **argv)
{
    int i, j, x, y, z, dr, dg, db, d1, d2, d3, r[240], g[240], b[240], f;
    int makecolormap_ppm = 0;
    unsigned char infile[49152];
    unsigned char outfile[16384];

    if (argc > 1 && argv[1][0] == '-' && argv[1][1] == 'm') {
	makecolormap_ppm = 1;
	printf("P3\n240 1\n255\n");
    }
    /* this generates the tvset pseudocolor map */
    for (i = 0; i < 256; i++) {
	    j = i - 16;
	    if (j > 224)
		break;
	    else {
		if (i < 16) {
		   r[i] = default_red[i];
		   g[i] = default_grn[i];
		   b[i] = default_blu[i];
		} else {
		r[i] = ((j % 25) / 5) * 63;
		g[i] = (j / 25) * 31;
		b[i] = (j % 5) * 63;
		}
	    }
	    if (makecolormap_ppm)
		printf("%3d %3d %3d\n", r[i], g[i], b[i]);
    }
    if (makecolormap_ppm)
	exit(0);

    if (argc < 3) {
	fprintf(stderr, "usage: %s infile outfile\n", argv[0]);
	exit(1);
    }
    if ((f=open(argv[1],O_RDONLY)) < 0) {
	perror(argv[1]);
	exit(1);
    }
    if (read(f,infile, 1024) != 1024) {
	fprintf(stderr, "cannot read ppm header\n");
	exit(1);
    }
    if (strncmp(infile, "P6", 2)) {
	fprintf(stderr, "input file is not a raw ppm file\n");
	exit(1);
    }
    i = nextline(infile, 0);
    if (infile[i] == '#')
	i = nextline(infile, i);
    j = nextline(infile, i);
    if(j - i < 8 || strncmp(&infile[i],"128 128", 7)) {
	fprintf(stderr, "PPM size must be 128x128 pixels\n");
	exit(1);
    }
    i = j;
    j = nextline(infile, i);
    if(j - i < 4 || strncmp(&infile[i], "255", 3)) {
	fprintf(stderr, "PPM color depth must be 255\n");
	exit(1);
    }
    lseek(f, j, SEEK_SET);	/* reposition at start of raw data */
    if ((i=read(f,infile,49152)) != 49152) {
	fprintf(stderr, "file size of %d bytes was expected\n", f + 49152);
	exit(1);
    }
    close(f);
    for (i = 0; i < 16384; i++) {
	dr = dg = db = 256;
	x = infile[i * 3];
	y = infile[i * 3 + 1];
	z = infile[i * 3 + 2];
	for (j=0; j<240; j++) {
	    d1 = abs(x - r[j]);
	    d2 = abs(y - g[j]);
	    d3 = abs(z - b[j]);
	    if (d2 < dg)	/* green carries highest weight */
		if (d1 < 33 && d3 < 33) {
		    outfile[i] = j;
		    dr = d1;
		    dg = d2;
		    db = d3;
	        }
	}
    }
    if ((f=open(argv[2],O_WRONLY)) < 0) {
	if ((f=creat(argv[2], 420)) < 0) {
	   perror(argv[2]);
	   exit(1);
	}
    }
    write(f,outfile,16384);
    close(f);
    exit(0);
}
