/* Generate ppm from raw tvset logo file for verification with standard tools
 */
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
/* the default colour table, for VGA+ colour systems */
int default_red[] = {0x00,0xaa,0x00,0xaa,0x00,0xaa,0x00,0xaa,
    0x55,0xff,0x55,0xff,0x55,0xff,0x55,0xff};
int default_grn[] = {0x00,0x00,0xaa,0x55,0x00,0x00,0xaa,0xaa,
    0x55,0x55,0xff,0xff,0x55,0x55,0xff,0xff};
int default_blu[] = {0x00,0x00,0x00,0x00,0xaa,0xaa,0xaa,0xaa,
    0x55,0x55,0x55,0x55,0xff,0xff,0xff,0xff};
main(int argc, char **argv)
{
    int i, j, r[240], g[240], b[240], f;
    unsigned char infile[16384], outfile[49152];

    /* this generates the tvset pseudocolor map */
    for (i = 0; i < 256; i++) {
	    j = i - 16;
	    if (j > 224)
		break;
	    else {
		if (i < 16) {
		   r[i] = default_red[i];
		   g[i] = default_grn[i];
		   b[i] = default_blu[i];
		} else {
		r[i] = ((j % 25) / 5) * 63;
		g[i] = (j / 25) * 31;
		b[i] = (j % 5) * 63;
		}
	    }
      }

    if (argc < 3) {
	fprintf(stderr, "usage: %s infile outfile\n", argv[0]);
	exit(1);
    }
    if ((f=open(argv[1],O_RDONLY)) < 0) {
	perror(argv[1]);
	exit(1);
    }
    if ((i=read(f,infile,16384)) != 16384) {
	fprintf(stderr, "input file not in tvlogo format\n");
	exit(1);
    }
    close(f);
    for (i = 0; i < 16384; i++) {
	j = infile[i];
	f = i * 3;
	outfile[f] = r[j];
	outfile[f + 1] = g[j];
	outfile[f + 2] = b[j];
    }
    if ((f=open(argv[2],O_WRONLY)) < 0) {
	if ((f=creat(argv[2], 420)) < 0) {
	   perror(argv[2]);
	   exit(1);
	}
    }
    write(f,"P6\n#Created by tvltoppm\n128 128\n255\n",36);/* don't change */
    write(f,outfile,49152);
    close(f);
    exit(0);
}
