/* xp.c 
 *   by Nathan Laredo (laredo@gnu.org)
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/Xlib.h>

int main(int argc, char **argv)
{
    int i;
    char *tmp;
    Display *mydisplay;

    if (!getenv("DISPLAY")) {
	fprintf(stderr, "DISPLAY not set.\n");
	exit(1);
    }
    if (!(mydisplay = XOpenDisplay(getenv("DISPLAY")))) {
	fprintf(stderr, "Unable to open display.\n");
	exit(1);
    }
    tmp = XFetchBytes(mydisplay, &i);
    XCloseDisplay(mydisplay);
    if (i > 0)
	write(fileno(stdout), tmp, i);
    putchar('\n');
    exit(0);
}				/* main */
