/* xticker.c 
 *   by Nathan Laredo (laredo@gnu.org)
 */

#define MAXTICKER 65536

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <X11/Xlib.h>

char myticker[144];
char myticker2[144];
char *tickdata = NULL;
struct stat st, oldst;
int ticksize;
Display *mydisplay;
int myscreen;
Window mywindow;
XFontStruct *font_struct;
Pixmap mypixmap;
GC mygc, mygc2, mygc3, mygcbg;
XGCValues gcvals;
XColor mycolor;
unsigned long myforeground, mybackground;

void setticker(int f)
{
    if (fstat(f, &st) < 0) {
	perror("fstat");
	exit(1);
    }
    memcpy(&oldst, &st, sizeof(st));
    ticksize = st.st_size;
    if (ticksize > MAXTICKER)
	ticksize = MAXTICKER;

    if (tickdata != NULL)
	return;

    if ((tickdata = mmap(0, ticksize, PROT_READ, MAP_SHARED, f, 0))
	== MAP_FAILED) {
	perror("mmap");
	exit(1);
    }
}

int main(int argc, char **argv)
{
    int i, j, f, animate, done = 0;
    char c;

    if (argc < 2) {
	fprintf(stderr, "usage: %s filetotick\n", argv[0]);
	exit(1);
    }
    if ((f = open(argv[1], O_RDONLY)) < 0) {
	perror(argv[1]);
	exit(1);
    }
    /* reset ticker */
    for (i=0; i<138; i++)
	myticker[i] = myticker2[i] = ' ';
    myticker[i] = myticker2[i++] = 0;
    myticker[i] = myticker2[i] = 0;

    setticker(f);
    if (!getenv("DISPLAY")) {
	fprintf(stderr, "DISPLAY not set.\n");
	exit(1);
    }
    if (!(mydisplay = XOpenDisplay(getenv("DISPLAY")))) {
	fprintf(stderr, "Unable to open display.\n");
	exit(1);
    }
    myscreen = DefaultScreen(mydisplay);
    mywindow = DefaultRootWindow(mydisplay);
    mybackground = BlackPixel(mydisplay, myscreen);
    myforeground = WhitePixel(mydisplay, myscreen);
    gcvals.foreground = mybackground;
    gcvals.background = myforeground;
    mygcbg = XCreateGC(mydisplay, mywindow,
	GCForeground | GCBackground, &gcvals);
    gcvals.foreground = myforeground;
    gcvals.background = mybackground;
    mygc = XCreateGC(mydisplay, mywindow, GCForeground | GCBackground, &gcvals);
    mycolor.flags = DoRed | DoGreen | DoBlue;
    mycolor.red = 32767;
    mycolor.green = 49152;
    mycolor.blue = 65535;
    mycolor.pad = 0;
    XAllocColor(mydisplay, DefaultColormap(mydisplay, myscreen), &mycolor);
    gcvals.foreground = mycolor.pixel;
    mygc2 = XCreateGC(mydisplay, mywindow,
		      GCForeground | GCBackground, &gcvals);
    mycolor.red = 65535;
    mycolor.green = 32767;
    mycolor.blue = 49152;
    XAllocColor(mydisplay, DefaultColormap(mydisplay, myscreen), &mycolor);
    gcvals.foreground = mycolor.pixel;
    mygc3 = XCreateGC(mydisplay, mywindow,
		      GCForeground | GCBackground, &gcvals);
    mypixmap = XCreatePixmap(mydisplay, mywindow, 1600, 50,
	DefaultDepth(mydisplay, myscreen));
    XFillRectangle(mydisplay, mypixmap, mygcbg, 0, 0, 1600, 50);
    XSetWindowBackgroundPixmap(mydisplay, mywindow, mypixmap);
    font_struct = XLoadQueryFont(mydisplay, "12x24");
    XSetFont(mydisplay, mygc, font_struct->fid);
    XSetFont(mydisplay, mygc2, font_struct->fid);
    XSetFont(mydisplay, mygc3, font_struct->fid);
    j = 0;
    while (!done) {
	if (ticksize < 5)	/* what can you say in 4 chars? */
	    done++;
	for (i = 0; i < ticksize; i++) {
	    if ((c = tickdata[i]) < 32)
		c = 32;
	    myticker[137] = c;
	    strcpy(&myticker[1], &myticker[2]);
	    if ((++j) > ticksize)
		j = 0;
	    if ((c = tickdata[j]) < 32)
		c = 32;
	    myticker2[137] = c;
	    if ((++j) > ticksize)
		j = 0;
	    if ((c = tickdata[j]) < 32)
		c = 32;
	    myticker2[138] = c;
	    strcpy(&myticker2[1], &myticker2[3]);
	    for (animate = 10; animate >= 0; animate-=2) {
		XDrawImageString(mydisplay, mypixmap, mygc2, 
			animate-24, 24, myticker, 137);
		XDrawImageString(mydisplay, mypixmap, mygc3,
			(animate<<1)-36, 48, myticker2, 137);
		if(XPending(mydisplay)) {	/* sync */
		    fprintf(stderr, "huh?\n");
		}
		XClearWindow(mydisplay, mywindow);	/* update */
		usleep(33333);		/* 30 fps */
	    }
	    if (!(i & 31)) {	/* check every 32nd char */
		if (fstat(f, &st) < 0) {	/* changed? */
		    perror(argv[1]);
		    exit(1);
		}
		if (memcmp(&st, &oldst, sizeof(st))) {
		    setticker(f);
		    break;
		}
	    }
	}
    }
    XCloseDisplay(mydisplay);
    close(f);
    exit(0);
}				/* main */
