/* xvbidebug.c 
 *   by Nathan Laredo (laredo@gnu.org)
 */
#undef  PAL_DECODE
#define DO_LINE 11
#undef  DATA_FROM_FILE "/home/ftp/vbidata"

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <linux/types.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Intrinsic.h>

Display *mydisplay;
Window mywindow;
Pixmap mypixmap;
GC mygc, mygc2, mygc3, mygcbg;
XGCValues gcvals;
XEvent myevent;
int myscreen;
XSizeHints myhint;
KeySym mykey;
XColor mycolor;
XFontStruct *font_struct;
unsigned long myforeground, mybackground;
XWindowAttributes attribs;	/* for vis, depth, width, height */
XSetWindowAttributes myattribs;	/* for window creation */
XPoint vbipoints[1600];		/* for drawing data */
long myevents;			/* keep track of our events */
char title[4096];		/* window title */
unsigned char vbibuf[65536];
char marquee[384];
unsigned char halfmhz[2048];	/* precalculated 0.5MHz cosine wave(for cc) */
unsigned char threemhz[2048];	/* precalculated 3MHz cosine wave(intercast)*/
#ifndef PAL_DECODE
#define HALFMHZ (2 * 0.500 * 3.14159265358979 / 28.636363)
#define THREEMHZ (2 * 2.5 * 3.14159265358979 / 28.636363)
#else
#define HALFMHZ (2 * 0.500 * 3.14159265358979 / 35.468950)
#define THREEMHZ (2 * 2.7 * 3.14159265358979 / 35.468950)
#endif
int pll = 0;

char *ccode = " !\"#$%&'()a+,-./0123456789:;<=>?@abcdefghijklmnopqrstuvwxyz[e]iouabcdefghijklmnopqrstuvwxyzc/Nn.";	/* this is NOT exactly right */

char outbuf[2048];

void makecostable(unsigned char *table, float k)
{
    int i;
    for (i=0; i<2048; i++)
	table[i] = (unsigned char)(127.0 + 127.0 * cos(k * i));
}

int parityok(int n)
{				/* check parity for 2 bytes packed in n */
    int j, k;
    for (k = 0, j = 0; j < 7; j++)
	if (n & (1 << j))
	    k++;
    if ((k & 1) && (n & 0x80))
	return 0;
    for (k = 0, j = 8; j < 15; j++)
	if (n & (1 << j))
	    k++;
    if ((k & 1) && (n & 0x8000))
	return 0;
    return 1;
}

int decodebit(unsigned char *data, int threshold)
{
    return (data[0] > threshold);
}

int ccdecode(unsigned char *vbiline)
{
    int max = 48, maxval = 128, minval = 255, i = 0, clk = 0, tmp = 0;
    int sample, packedbits = 0;

    for (i=0; i<250; i++) {
	sample = vbiline[i];
	if (sample - maxval > 10)
	    (maxval = sample, max = i);
	if (sample < minval)
	    minval = sample;
	if (maxval - sample > 40)
	    break;
    }
    XDrawLine(mydisplay, mypixmap, mygc2, max>>1, 30, max>>1, 255);
    sample = ((maxval + minval) >> 1);
    pll = max;

    /* found clock lead-in, double-check start */
#ifndef PAL_DECODE
    i = max + 478;
    XDrawLine(mydisplay, mypixmap, mygc2, i >> 1, 30, i >> 1, 256);
#else
    i = max + 538;
#endif
    if (!decodebit(&vbiline[i], sample))
	return 0;
    XDrawLine(mydisplay, mypixmap, mygc, i >> 1, 30, i >> 1, 256);
#ifndef PAL_DECODE
    tmp = i + 57;		/* tmp = data bit zero */
#else
    tmp = i + 71;
#endif
    for (i = 0; i < 16; i++) {
#ifndef PAL_DECODE
	clk = tmp + i * 57;
#else
	clk = tmp + i * 71;
#endif
	if (decodebit(&vbiline[clk], sample)) {
	    XDrawLine(mydisplay, mypixmap, mygc, clk >> 1, 30,
		      clk >> 1, 256 - sample);
	    packedbits |= 1 << i;
	} else
	    XDrawLine(mydisplay, mypixmap, mygc, clk >> 1, 256 - sample,
		      clk >> 1, 256);
    }
    if (parityok(packedbits))
	return packedbits;
    return 0;
}				/* ccdecode */


int ProcessLine(unsigned char *s)
{
    int w1, b1, b2;
    static lastchar = 0, mode = 0;
    static nocc = 0;
    int m, n;

    m = strlen(outbuf);
    w1 = ccdecode(s);
    if (!w1)
	nocc++;
    sprintf(title, "%d", nocc);
    XDrawString(mydisplay, mypixmap, mygc, 20, 245, title, strlen(title));

    b1 = w1 & 0x7f;
    b2 = (w1 >> 8) & 0x7f;
    if ((b1 & 96)) {
	if (b1 > 31) {
	    strncat(outbuf, &ccode[b1 - 32], 1);
	    if (lastchar == '.' || lastchar == '['
		|| lastchar == '>' || lastchar == ']'
		|| lastchar == '!' || lastchar == '?')
		outbuf[strlen(outbuf) - 1] =
		    toupper(ccode[b1 - 32]);
	    if (b1 > 32)
		lastchar = ccode[b1 - 32];
	}
	if (b2 > 31) {
	    strncat(outbuf, &ccode[b2 - 32], 1);
	    if (lastchar == '.' || lastchar == '['
		|| lastchar == '>' || lastchar == ']'
		|| lastchar == '!' || lastchar == '?')
		outbuf[strlen(outbuf) - 1] =
		    toupper(ccode[b2 - 32]);
	    if (b2 > 32)
		lastchar = ccode[b2 - 32];
	}
    }
    if (!(b1 & 96) && b1 && *outbuf)
	if (outbuf[strlen(outbuf) - 1] != ' ')
	    strncat(outbuf, ccode, 1);
    n = strlen(outbuf);
    if (n - m)
	strncat(marquee,&outbuf[m], n - m);
    if (!(b1 & 96) && b1 && *outbuf) {
	if (++mode > 4) {
	    fprintf(stderr, "%s\n", outbuf);
	    *outbuf = 0;
	    mode = 0;
	}
    }
    return n - m;
}				/* ProcessLine */

void init_display(int argc, char **argv)
{

    if (!getenv("DISPLAY")) {
	fprintf(stderr, "DISPLAY not set.\n");
	exit(1);
    }
    if (!(mydisplay = XOpenDisplay(getenv("DISPLAY")))) {
	fprintf(stderr, "Unable to open display.\n");
	exit(1);
    }
    mybackground = BlackPixel(mydisplay, myscreen);
    myforeground = WhitePixel(mydisplay, myscreen);
    myhint.width = 800;
    myhint.height = 256;
    myhint.max_width = 800;
    myhint.max_height = 256;
    myhint.min_width = 800;
    myhint.min_width = 256;
    myhint.x = 100;
    myhint.y = 900;
    /* to add aspect ratio restriction, add to mask below */
    myhint.flags = PSize | PMinSize | PMaxSize | PPosition;
    myevents = myattribs.event_mask = KeyPressMask | ButtonPressMask;
    myattribs.background_pixel = mybackground;
    mywindow = XCreateWindow(mydisplay, DefaultRootWindow(mydisplay),
		myhint.x, myhint.y, myhint.width, myhint.height, 0,
		attribs.depth, InputOutput, attribs.visual,
		CWEventMask | CWBackPixel, &myattribs);
    sprintf(title, "xvbidebug %d", DO_LINE);
    XSetStandardProperties(mydisplay, mywindow, title, title, None, argv,
			   argc, &myhint);
    gcvals.foreground = mybackground;
    gcvals.background = myforeground;
    mygcbg = XCreateGC(mydisplay, mywindow,
	GCForeground | GCBackground, &gcvals);
    gcvals.foreground = myforeground;
    gcvals.background = mybackground;
    mygc = XCreateGC(mydisplay, mywindow, GCForeground | GCBackground, &gcvals);
    mycolor.flags = DoRed | DoGreen | DoBlue;
    mycolor.red = 32767;
    mycolor.green = 49152;
    mycolor.blue = 65535;
    mycolor.pad = 0;
    XAllocColor(mydisplay, DefaultColormap(mydisplay, myscreen), &mycolor);
    gcvals.foreground = mycolor.pixel;
    mygc2 = XCreateGC(mydisplay, mywindow,
		      GCForeground | GCBackground, &gcvals);
    mycolor.red = 65535;
    mycolor.green = 32767;
    mycolor.blue = 49152;
    XAllocColor(mydisplay, DefaultColormap(mydisplay, myscreen), &mycolor);
    gcvals.foreground = mycolor.pixel;
    mygc3 = XCreateGC(mydisplay, mywindow,
		      GCForeground | GCBackground, &gcvals);
    XMapRaised(mydisplay, mywindow);
    mypixmap = XCreatePixmap(mydisplay, mywindow, 800, 256,
	DefaultDepth(mydisplay, myscreen));
    XFillRectangle(mydisplay, mypixmap, mygcbg, 0, 0, 800, 256);
    XSetWindowBackgroundPixmap(mydisplay, mywindow, mypixmap);
}

int main(int argc, char **argv)
{
    fd_set rdfs;
    int vbifd, xfd, done = 0, i, j = DO_LINE * 2048, k, animate = 0;
    unsigned int *vbicount, oldcount = 0, dropcount = 0, scrollwait = 0;
    int filter;

#ifdef DATA_FROM_FILE
    if ((vbifd = open(DATA_FROM_FILE, O_RDONLY)) < 0) {
	perror("open /dev/vbi0");
	exit(1);
    }
#else
    if ((vbifd = open("/dev/vbi0", O_RDONLY)) < 0) {
	perror("open /dev/vbi0");
	exit(1);
    }
#endif
    init_display(argc, argv);
    for (i = 0; i < 119; i++)
	marquee[i] = ' ';
    marquee[i] = 0;
    makecostable(halfmhz, HALFMHZ);
    makecostable(threemhz, THREEMHZ);

    for (i = 0; i < 1600; i++)
	vbipoints[i].x = i / 2;

    xfd = ConnectionNumber(mydisplay);
    /* Main event loop */
    while (!done) {
	FD_ZERO(&rdfs);
	FD_SET(xfd, &rdfs);
	FD_SET(vbifd, &rdfs);
	select(FD_SETSIZE, &rdfs, NULL, NULL, NULL);
	if (FD_ISSET(xfd, &rdfs))
	    while (XPending(mydisplay)) {
		XNextEvent(mydisplay, &myevent);
		j += 2048;
		if (j >= 65536)
		    j = 0;
		sprintf(title, "xvbidebug %d", j >> 11);
		XStoreName(mydisplay, mywindow, title);
	    }
	if (FD_ISSET(vbifd, &rdfs)) {
	    if (read(vbifd, vbibuf, 65536) < 65536)
		done++;
	    vbicount = (unsigned int *) &vbibuf[65532];
#if 0
	    if (oldcount && oldcount + 1 != *vbicount) {
		dropcount += (*vbicount - oldcount);
	    }
#endif
	    oldcount = *vbicount;
#if 1
	    if (oldcount & 1)
		continue;
#endif
	    XFillRectangle(mydisplay, mypixmap, mygcbg, 0, 0, 800, 256);

	    for (i = 0; i < 1600; i++)
		vbipoints[i].y = 256 - vbibuf[i + j];
	    XDrawLines(mydisplay, mypixmap, mygc3, vbipoints,
			1600, CoordModeOrigin);

#if 1
	    for (k = 1; k < 7; k++) {
#if 1
		    for (i = 0; i < 1600; i++) {
			    vbibuf[i + j] = (vbibuf[i + j + k] + vbibuf[i + j]) / 2;
		    }
#endif
#if 1
		    for (i = 1600; i > 0; i--) {
			    vbibuf[i + j] = (vbibuf[i + j + k] + vbibuf[i + j]) / 2;
		    }
#endif
	    }
#endif

	    scrollwait += ProcessLine(&vbibuf[j]);
#if 0
	    for (i = 0; i < 1600; i++)
		vbipoints[i].y = 256 - halfmhz[170 + i - pll];
	    XDrawLines(mydisplay, mypixmap, mygc2, vbipoints,
			1600, CoordModeOrigin);
#endif
	    sprintf(title, "%d %d", dropcount, *vbicount);
	    XDrawString(mydisplay, mypixmap, mygc, 20, 20,
			title, strlen(title));
	    for (i = 0; i < 1600; i++)
		vbipoints[i].y = 256 - vbibuf[i + j];
	    XDrawLines(mydisplay, mypixmap, mygc, vbipoints,
		       1600, CoordModeOrigin);
	    if (animate)
		animate -= ((scrollwait > 100) ? animate : 2);
	    if (!animate && scrollwait > 1) {
		strcpy(marquee, &marquee[2]);
		scrollwait -= 2;
		animate = (scrollwait > 100) ? 0 : 12;
	    }
	    sprintf(title, "%s", marquee);
	    XDrawString(mydisplay, mypixmap, mygc, 90+animate, 20,
			title, strlen(title));
	    XClearWindow(mydisplay, mywindow);	/* repaint */
#ifdef DATA_FROM_FILE
	    usleep(333333);
#endif
	}
    }				/* while */
    close(vbifd);
    XFreeGC(mydisplay, mygc);
    XFreeGC(mydisplay, mygc2);
    XFreeGC(mydisplay, mygcbg);
    XFreePixmap(mydisplay, mypixmap);
    XDestroyWindow(mydisplay, mywindow);
    XCloseDisplay(mydisplay);
    exit(0);
}				/* main */
